function [metnum_match, metnum_match_coeff] = coeff_met(out, metname, index) % out is the reactant/product with its coefficient in string form 

stoich_col = zeros(length(metname),1);
global stoich tp err_coeff 
global depo_metnum_match % stores the counted/processed met. names
                         % to test if any metabolite remains untouched.
out = strtrim(out); % a metabolite either with or without coefficients
tp = 1; %as a counter

if length(strmatch(out, metname, 'exact')) ~= 0    % if  the stoich. coeff is 1 and not explicitly written in the input file. 
   metnum_match = strmatch(out,metname,'exact');   % identify the place of metabolite 'out' in 'metname' vector.
   metnum_match_coeff = -1;                % assign stoichiometric coefficient as -1; 
   depo_metnum_match(metnum_match)= 1;
else
   space_count = findstr(' ',char(out)); % determine the number of spaces in 'out'.
   
   if length(space_count) == 1 % if the number of spaces is ONE.
       [outa, outb] = strread(char(out),'%s %s','delimiter',' '); % separate the reactant from 
                                                                  % its stoich. coeff. if available.
                                                                  
       if length(str2num(char(outa)))~= 0 %if there exists a stoich. coeff (different than 1) for the metabolite.
           metnum_match = strmatch(outb,metname,'exact'); % identify the place of metabolite 'outb' in 'metname' vector.
           depo_metnum_match(metnum_match)= 1;
           metnum_match_coeff = -str2num(char(outa)); %assign stoichiometric coefficient as -outa
       elseif length(str2num(char(outa))) == 0; figure; xlabel(out);
       end
        
       
    elseif length(space_count) == 2 % if the number of spaces is TWO.
       [outa, outb, outc] = strread(char(out),'%s %s %s','delimiter',' ');

       if length(str2num(char(outa)))~= 0 % if there exists a stoich. coeff for the metabolite.
           outb = char(strtrim(outb)); % convert to character arrays and remove blanks.
           outc = char(strtrim(outc));
           comb = cellstr(strcat([outb blanks(1) outc])); % put the other pieces back after the stoichiometry is identified.
           metnum_match = strmatch(comb,metname,'exact'); % identify the place of metabolite 'outb outc' in 'metname' vector.
           depo_metnum_match(metnum_match)= 1;
           metnum_match_coeff = -str2num(char(outa)); % assign stoichiometric coefficient as -outa
       elseif length(str2num(char(outa))) == 0; figure; xlabel(out);
       end
       
       
    else
     figure; xlabel(strcat(out,num2str(index))); % else if the number of space is higher than TWO.
     err_coeff{tp} = strcat(out,num2str(index));  % else if the number of space is higher than four.

   end       %   if length(space_count) == 1 : 4 % if the number of spaces is ONE. (to FOUR)
 tp = tp + 1;     
end          %   if length(strmatch(out, metname, 'exact')) ~= 0 : else

   
return


